<?php

/*
	Copyright (c) IT7 Networks Inc
	http://it7.net
*/

require_once('config.php');
require_once('functions.php');
require_once('header.php');


$top = array();
$limit = 30;
if ($_GET ['records']) $limit = intval($_GET ['records']);

$sort = 'smtp';
if ($_GET ['sort'] && !preg_match('/[^a-z0-9_]/', $_GET ['sort'])) $sort = $_GET ['sort'];

$query = "SELECT * FROM `top` ORDER BY `$sort` DESC, `packets_15` DESC LIMIT $limit";
$result = query($query, true);
if (!$result) die ('There\'s no data in the database yet, so there is nothing to display. Data is uploaded by nodewatch every 10 seconds.');
while ($row = mysql_fetch_assoc($result)) {
    $top [] = $row;
}


$query = "SELECT * FROM `limits_kbps`";
$result = query($query);
$limits_kbps = mysql_fetch_assoc($result);
$limits_kbps = unserialize($limits_kbps ['limits_kbps']);

// this table may not exist...
$r = mysql_query('SELECT 1 FROM `limits_cpu`');
if ($r) {
    $query = "SELECT * FROM `limits_cpu`";
    $result = query($query);
    $limits_cpu = mysql_fetch_assoc($result);
    $limits_cpu = unserialize($limits_cpu ['limits_cpu']);
}

$query = "SELECT * FROM `limits_packets`";
$result = query($query);
$limits_packets = mysql_fetch_assoc($result);
$limits_packets = unserialize($limits_packets ['limits_packets']);


$output = '';

$output .= '<table>';
$output .= '<tr>';

$output .= '<th>Last update,</th>';
$output .= '<th></th>';
$output .= '<th></th>';
$output .= '<th></th>';
$output .= '<th></th>';
$output .= '<th></th>';
$output .= '<th></th>';
if ($limits_cpu) {
    $output .= '<th colspan=' . count($limits_cpu) . ' style="background-color:#e0f5e0">Average CPU (%) per interval</th>';
}
$output .= '<th colspan=' . count($limits_kbps) . ' style="background-color:#e0f5e0">Average I/O (MBps) per interval</th>';
$output .= '<th colspan=' . count($limits_packets) . ' style="background-color:#e8e8f5">Average packets per interval</th>';
$output .= '</tr>';

$output .= '<tr>';
$output .= '<th>seconds ago</th>';
$output .= "<th><a href='?records=$limit&sort=hostname'>Node</a></th>";
$output .= "<th><a href='?records=$limit&sort=veid'>VPS ID</th>";
$output .= "<th><a href='?records=$limit&sort=ip'>VPS IP</th>";
$output .= "<th><a href='?records=$limit&sort=conntrack'>CONN</th>";
$output .= "<th><a href='?records=$limit&sort=ssh'>SSH</th>";
$output .= "<th><a href='?records=$limit&sort=smtp'>SMTP</th>";
if ($limits_cpu) {
    foreach ($limits_cpu as $key => $value) {
        $output .= "<th style='background-color:#e0f5e0'><a href='?records=$limit&sort=cpu_$key'>$key s</a></th>";
    }
}
foreach ($limits_kbps as $key => $value) {
    $output .= "<th style='background-color:#e0f5e0'><a href='?records=$limit&sort=io_$key'>$key s</a></th>";
}
foreach ($limits_packets as $key => $value) {
    $output .= "<th style='background-color:#e8e8f5'><a href='?records=$limit&sort=packets_$key'>$key s</a></th>";
}
$output .= '</tr>';
foreach ($top as $id => $data) {

    $last_update = time() - $data['last_update'];

    $row_style = '';
    if ($last_update > 30) $row_style = " style='color:c0c0c0;'";

    $data_smtp = $data ['smtp'];
    if ($data ['smtp_whitelisted']) $data_smtp .= ' W';
    $data_ssh = $data ['ssh'];
    if ($data ['ssh_whitelisted']) $data_ssh .= ' W';
    $data_conntrack = $data ['conntrack'];
    if ($data ['conntrack_whitelisted']) $data_conntrack .= ' W';

    $output .= "<tr$row_style>";
    $output .= "<td>{$last_update}</td>";
    $output .= "<td>{$data['hostname']}</td>";
    $output .= "<td>{$data['veid']}</td>";
    $output .= "<td>{$data['ip']}</td>";
    $output .= "<td>{$data_conntrack}</td>";
    $output .= "<td>{$data_ssh}</td>";
    $output .= "<td>{$data_smtp}</td>";

    if ($limits_cpu) {
        foreach ($limits_cpu as $key => $value) {
            $cpu = $data ['cpu_' . $key];
            $output .= "<td>$cpu</td>";
        }
    }

    foreach ($limits_kbps as $key => $value) {
        $mbps = $data ['io_' . $key];
        $output .= "<td>$mbps</td>";
    }


    foreach ($limits_packets as $key => $value) {
        $pps = $data ['packets_' . $key];
        $output .= "<td>$pps</td>";
    }

    $output .= '</tr>';
}
$output .= '</table>';


die ($output);
?>