<?php

/*
    Copyright (c) IT7 Networks Inc
    http://it7.net
*/

require('config.php');
require('functions.php');

$dbversion = 2;

$profiling_start = microtime(true);

$hash = md5($nodewatch_web_password . 'b90a8eynr98bayergAghAFsAdga');

if ($_POST ['hash'] != $hash) die;
if ($_POST ['alive']) die ('alive');


$s = $_POST ['data'];
$s = base64_url_decode($s);
$top = unserialize($s);
if (count($top ['smtp'] ['current']) < 1) {
    die ("Not enoungh data\n");
}
echo "Yum! Got " . strlen($s) . " bytes\n";


// auto-flush database when upgrading to newer version
if ($top ['dbversion']) {
    if ($dbversion < $top ['dbversion']) {
        die ("Nodewatch-web needs to be updated to a newer version.");
    }
    $current_version = 0;
    $query = "SELECT dbversion FROM `dbversion`";
    $result = query($query, true);
    if ($result) {
        if ($row = mysql_fetch_assoc($result)) {
            $current_version = $row ['dbversion'];
        }
    }

    if ($current_version < $top ['dbversion']) {
        $query = 'DROP TABLE IF EXISTS `dbversion`';
        query($query);
        $query = 'DROP TABLE IF EXISTS `limits_cpu`';
        query($query);
        $query = 'DROP TABLE IF EXISTS `limits_kbps`';
        query($query);
        $query = 'DROP TABLE IF EXISTS `limits_packets`';
        query($query);
        $query = 'DROP TABLE IF EXISTS `top`';
        query($query);

        $query = 'CREATE TABLE `dbversion` (dbversion INT)';
        query($query);
        $query = 'INSERT INTO `dbversion` (`dbversion`) VALUES (\'' . $top ['dbversion'] . '\')';
        query($query);
    }
}

// Newer versions of Nodewatch support cpu load. 
// Database will not be properly created with older versions of Nodewatch.
if ($dbversion != $top ['dbversion']) {
    die ("Version mismatch. Please update Nodewatch (server daemon) as well as Nodewatch-web script to the latest version.");
}

$query = 'CREATE TABLE IF NOT EXISTS `limits_cpu` (id INT, PRIMARY KEY (id), limits_cpu VARCHAR (255) )';
query($query);
$query = 'CREATE TABLE IF NOT EXISTS `limits_kbps` (id INT, PRIMARY KEY (id), limits_kbps VARCHAR (255) )';
query($query);
$query = 'CREATE TABLE IF NOT EXISTS `limits_packets` (id INT, PRIMARY KEY (id), limits_packets VARCHAR (255) )';
query($query);

$query = 'REPLACE INTO `limits_cpu` (`id`, `limits_cpu` ) VALUES (\'1\', \'' . $top ['limits_cpu'] . '\')';
query($query);
$query = 'REPLACE INTO `limits_kbps` (`id`, `limits_kbps` ) VALUES (\'1\', \'' . $top ['limits_kbps'] . '\')';
query($query);
$query = 'REPLACE INTO `limits_packets` (`id`, `limits_packets` ) VALUES (\'1\', \'' . $top ['limits_packets'] . '\')';
query($query);


$query = 'CREATE TABLE IF NOT EXISTS `top` (
        dbversion INT, 
        last_update INT, 
        hostname VARCHAR (64), 
        veid INT,
        PRIMARY KEY (veid), 
        ip VARCHAR (32),
        ssh INT,
        ssh_whitelisted INT,
        smtp INT,
        smtp_whitelisted INT,
        conntrack INT,
        conntrack_whitelisted INT,
';

$limits_cpu = @unserialize($top ['limits_cpu']);
$limits_kbps = @unserialize($top ['limits_kbps']);
$limits_packets = @unserialize($top ['limits_packets']);
$smtp_whitelist = @unserialize($top ['smtp_whitelist']);
$ssh_whitelist = @unserialize($top ['ssh_whitelist']);
$conntrack = @unserialize($top ['conntrack_whitelist']);
if (!is_array($smtp_whitelist)) $smtp_whitelist = array();
if (!is_array($ssh_whitelist)) $ssh_whitelist = array();
if (!is_array($conntrack_whitelist)) $conntrack_whitelist = array();


foreach ($limits_cpu as $key => $data) {
    $query .= "cpu_$key FLOAT, ";
}

foreach ($limits_kbps as $key => $data) {
    $query .= "io_$key FLOAT, ";
}

foreach ($limits_packets as $key => $data) {
    $query .= "packets_$key INT, ";
}

$query .= ' filler INT)';

query($query);


function addField($fields, $field)
{
    if ($fields) $fields .= ', ';
    $fields .= '`' . $field . '`';
    return $fields;
}

function addValue($values, $val)
{
    if ($values) $values .= ', ';
    $values .= "'" . $val . "'";
    return $values;
}

$all_values = '';
foreach ($top ['smtp'] ['current'] as $veid => $data) {
    $fields = '';
    $values = '';
    if ($all_values) $all_values .= ",\n";

    $fields = addField($fields, 'hostname');
    $values = addValue($values, $top ['hostname']);

    $fields = addField($fields, 'last_update');
    $values = addValue($values, time());

    $fields = addField($fields, 'veid');
    $values = addValue($values, $veid);

    $ips = $top ['ip'] [$veid];
    $ip = $ips [0];

    $fields = addField($fields, 'ip');
    $values = addValue($values, $ip);

    $fields = addField($fields, 'smtp');
    $values = addValue($values, $top ['smtp']['current'] [$veid]);
    if (in_array($veid, $smtp_whitelist)) {
        $fields = addField($fields, 'smtp_whitelisted');
        $values = addValue($values, 1);
    } else {
        $fields = addField($fields, 'smtp_whitelisted');
        $values = addValue($values, 0);
    }

    $fields = addField($fields, 'ssh');
    $values = addValue($values, $top ['ssh']['current'] [$veid]);
    if (in_array($veid, $ssh_whitelist)) {
        $fields = addField($fields, 'ssh_whitelisted');
        $values = addValue($values, 1);
    } else {
        $fields = addField($fields, 'ssh_whitelisted');
        $values = addValue($values, 0);
    }

    if ($top ['dbversion'] >= 2) {
        $fields = addField($fields, 'conntrack');
        $values = addValue($values, $top ['conntrack']['current'] [$veid]);
        if (in_array($veid, $conntrack_whitelist)) {
            $fields = addField($fields, 'conntrack_whitelisted');
            $values = addValue($values, 1);
        } else {
            $fields = addField($fields, 'conntrack_whitelisted');
            $values = addValue($values, 0);
        }
    }

    foreach ($top ['io'] as $key => $data) {
        $mbps = $top ['io'][$key] [$veid];
        if (isset ($mbps)) {
            $mbps = $mbps / 1024;
            if ($mbps >= 100) {
                $mbps = number_format($mbps, 0);
            } elseif ($mbps > 0.1) {
                $mbps = number_format($mbps, 1);
            } else {
                $mbps = '0';
            }
        }
        $fields = addField($fields, "io_$key");
        $values = addValue($values, $mbps);
    }


    foreach ($top ['cpu'] as $key => $data) {
        $cpu = $top ['cpu'][$key] [$veid];
        $fields = addField($fields, "cpu_$key");
        $values = addValue($values, $cpu);
    }


    foreach ($top ['packets'] as $key => $data) {
        $pps = $top ['packets'][$key] [$veid];
        $fields = addField($fields, "packets_$key");
        $values = addValue($values, $pps);
    }

    $all_values .= "($values)";
}

$query = "REPLACE INTO `top` ($fields) VALUES $all_values";
query($query);

$profiling_delta = round((microtime(true) - $profiling_start) * 1000);

echo "All imported. Took $profiling_delta ms\n";


?>